<?php
require_once __DIR__ . '/../utils/Config.php'; require_once SRC_PATH . '/classes/Game.php'; require_once SRC_PATH . '/classes/UpgradeManager.php'; class UpgradeController { private $db; private $game; private $upgradeManager; public function __construct($game) { $this->db = Database::getInstance(); $this->game = $game; $this->upgradeManager = $game->getUpgradeManager(); } public function getAvailableUpgrades() { return $this->upgradeManager->getAvailableUpgrades(); } public function purchaseUpgrade($id) { return $this->upgradeManager->purchaseUpgrade($id); } public function getUpgrades() { $query = "SELECT * FROM upgrades ORDER BY type, release_year, base_cost"; $allUpgrades = $this->db->query($query)->fetchAll(PDO::FETCH_ASSOC); $categorizedUpgrades = [ 'hosting' => [], 'dedicated_server' => [], 'hosting_addon' => [], 'security' => [], 'tools' => [], 'internet' => [], 'upload_storage' => [], 'website' => [], 'marketing' => [], 'mining' => [] ]; foreach ($allUpgrades as $upgradeData) { $upgrade = new Upgrade($upgradeData); $type = $upgrade->getType(); $upgradeInfo = [ 'id' => $upgrade->getId(), 'name' => $upgrade->getName(), 'description' => $upgrade->getDescription(), 'cost' => $upgrade->calculateCost(), 'release_year' => $upgrade->getReleaseYear(), 'level' => $upgrade->getLevel(), 'max_level' => $upgrade->getMaxLevel(), 'type' => $upgrade->getType(), 'acquired' => $upgrade->isAcquired(), 'effects' => $upgrade->getEffects() ]; $categorizedUpgrades[$type][] = $upgradeInfo; } header('Content-Type: application/json'); echo json_encode([ 'success' => true, 'upgrades' => $categorizedUpgrades ]); exit; } } if (isset($_GET['action'])) { $game = new Game(); $controller = new UpgradeController($game); if ($_GET['action'] === 'getUpgrades') { $controller->getUpgrades(); } } 